/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schematic;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import se.mickelus.tetra.module.data.MaterialData;
import se.mickelus.tetra.module.data.ToolData;
import se.mickelus.tetra.module.schematic.OutcomeDefinition;
import se.mickelus.tetra.module.schematic.UniqueOutcomeDefinition;

@ParametersAreNonnullByDefault
public class MaterialOutcomeDefinition
extends OutcomeDefinition {
    public ResourceLocation[] materials = new ResourceLocation[0];
    public int countOffset = 0;
    public float countFactor = 1.0f;
    public int toolOffset = 0;
    public float toolFactor = 1.0f;
    public float experienceOffset = 0.0f;
    public float experienceFactor = 0.0f;

    public OutcomeDefinition combine(MaterialData materialData) {
        UniqueOutcomeDefinition result = new UniqueOutcomeDefinition();
        if (materialData.hiddenOutcomes) {
            result.hidden = true;
        }
        result.moduleKey = this.moduleKey;
        if (this.moduleVariant != null) {
            result.moduleVariant = this.moduleVariant + materialData.key;
            result.improvements = Stream.of(this.improvements, materialData.improvements).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::max));
        } else if (!this.improvements.isEmpty()) {
            result.improvements = this.improvements.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey() + materialData.key, Map.Entry::getValue));
        }
        result.material = materialData.material.offsetCount(this.countFactor, this.countOffset);
        if (materialData.requiredTools != null) {
            result.requiredTools = ToolData.offsetLevel(materialData.requiredTools, this.toolFactor, this.toolOffset);
        }
        result.requiredTools = ToolData.merge(this.requiredTools, Optional.ofNullable(materialData.requiredTools).map(materialTools -> ToolData.offsetLevel(materialTools, this.toolFactor, this.toolOffset)).orElse(null));
        result.experienceCost = Math.round(materialData.experienceCost * this.experienceFactor + this.experienceOffset);
        return result;
    }
}

